/*
 * SPDX-FileCopyrightText: 2019-2023 Mattia Basaglia <dev@dragon.best>
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#pragma once

#include <memory>
#include <QImage>
#include <QObject>

#include "math/bezier/bezier.hpp"

namespace glaxnimate::utils::trace {

class TraceOptions
{
public:
    TraceOptions();
    ~TraceOptions();

    qreal smoothness() const;
    void set_smoothness(qreal smoothness);

    int min_area() const;
    void set_min_area(int min_area);

private:
    friend class Tracer;
    class Private;
    std::unique_ptr<Private> d;
};

class Tracer : public QObject
{
    Q_OBJECT
public:
    Tracer(const QImage& image, const TraceOptions& options);
    ~Tracer();

    bool trace(math::bezier::MultiBezier& output);

    static QString potrace_version();

    void set_progress_range(double min, double max);

    void set_target_alpha(int threshold, bool invert);
    void set_target_color(const QColor& color, qint32 tolerance);
    void set_target_index(uchar index);

Q_SIGNALS:
    void progress(double value);

private:
    class Private;
    std::unique_ptr<Private> d;
};

std::map<QRgb, std::vector<QRectF>> trace_pixels(QImage image);

} // namespace glaxnimate::utils::trace
