/*
 * Copyright (c) 2018 Sune Vuorela <sune@vuorela.dk>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

#pragma once
#include <QMainWindow>
#include <memory>

class ActiveDocument;
class FsPane;
class MainPane;
class Scanner;

/**
 *Main window
 */
class MainWindow : public QMainWindow
{
    Q_OBJECT
public:
    MainWindow(QWidget* parent = nullptr);
    ~MainWindow();
Q_SIGNALS:
    /** private signal to help whenever pane clearing (Usually following open folder) is needed*/
    void clear(QPrivateSignal = QPrivateSignal{});
private Q_SLOTS:
    /** When open folder is invoked*/
    void openFolder();
    /** When edit recipe is invoked */
    void editActiveRecipe();
    /** creates a recipe and edits */
    void newRecipe();
    /** writes message to the status bar (for a short interval)*/
    void notifyStatusBar(const QString& message);
    /** opens random recipe*/
    void showRandomRecipe();
private:
    /** Sets the current folder (and notifies whoever needs it) */
    void setCurrentFolder(const QString& folder);
    std::unique_ptr<ActiveDocument> m_activeDocument;
    FsPane* m_fsPane;
    MainPane* m_mainPane;
    std::unique_ptr<Scanner> m_scanner;
    QString m_currentFolder;
};
