// SPDX-FileCopyrightText: 2025 Johannes Zarl-Zierl <johannes@zarl-zierl.at>
//
// SPDX-License-Identifier: GPL-2.0-or-later

#ifndef QTMULTIMEDIADISPLAY_H
#define QTMULTIMEDIADISPLAY_H

#include "VideoDisplay.h"

#include <QMediaPlayer>

class QVideoWidget;

namespace Viewer
{

class VideoToolBar;

class QtMultimediaDisplay : public Viewer::VideoDisplay
{
    Q_OBJECT
public:
    QtMultimediaDisplay(QWidget *parent);
    ~QtMultimediaDisplay() override;
    bool setImageImpl(DB::ImageInfoPtr info, bool forward) override;
    bool isPaused() const override;
    bool isPlaying() const override;
    QImage screenShoot() override;
    void relativeSeek(int msec) override;
    bool canRotate() override;
    bool canZoom() override;

public Q_SLOTS:
    void stop() override;
    void playPause() override;
    void restart() override;
    /**
     * @brief rotate is not supported by QtMultimediaDisplay.
     * @param info
     */
    void rotate(const DB::ImageInfoPtr &info) override;
    /**
     * @brief changeVolume changes the audio volume of the video.
     * @param newVolumePercent the new volume in percent between 0 and 100
     */
    void changeVolume(int newVolumePercent);
    /**
     * @brief setMuted mutes or unmutes the audio volume of the video.
     * After muting and then unmuting again, the audio volume is the same as before muting.
     * @param mute
     */
    void setMuted(bool mute);

protected:
    void setup();

protected Q_SLOTS:
    void updatePlaybackState(QMediaPlayer::PlaybackState newState);
    void updateDuration(qint64 duration);
    void updateVolume(float newVolumeVolt);
    void updateMuteState(bool mute);

private:
    QMediaPlayer *m_mediaPlayer;
    QVideoWidget *m_videoWidget;
    VideoToolBar *m_videoToolBar;
    void errorOccurred(QMediaPlayer::Error, const QString &errorString);
};

} // namespace Viewer

#endif // QTMULTIMEDIADISPLAY_H
// vi:expandtab:tabstop=4 shiftwidth=4:
