# KReport - a framework for the creation and generation of reports in multiple formats

## Introduction

The KReport framework implements reporting functionality for creation
of [reports in MS Access](https://support.office.com/article/e0869f59-7536-4d19-8e05-7158dcd3681c)
style. They are also similar to [SAP Crystal Reports](http://www.sap.com/solution/sme/software/analytics/crystal-reports/index.html)
and [FileMaker reports](https://support.claris.com/s/answerview?anum=13754).

Reports can be created interactively and programmatically. They can be previewed on screen,
printed, and saved in a variety of formats such as HTML, PDF and OpenDocument.

Reports of this kind offer a way to view, format, and summarize the information.
For example a simple report of contact phone numbers can be prepared, or a more complex
report on sales for different products, regions, and periods of time.

A report is often filled with information from a database. There are many use cases:

* The data can be displayed, summarized, sorted and grouped
* Totals can be computed and displayed
* Single or multiple records of data can be placed on a page
* Details for individual data records can be placed in a layout
* Labels can be created
* The various report sections, such as title, header or footer, can be sized to suit
* Reports can be generated on demand, thus eliminating saving them in files for further use


KReport is a part of the [KEXI project](http://www.kexi-project.org).

Project maintainer: Adam Pigg <adam@piggz.co.uk>

*If you are reading this on GitHub, be aware that this is just a mirror.
Our real code repository [is located here](https://invent.kde.org/libraries/kreport).*

# Building KReport

KReport uses the CMake build system.

# Donate Money

If you love KReport, you can help developers to build new incredible features or
enhance new ones. Thanks in advance for your generous donations.
For more information, [look here](https://community.kde.org/Kexi/Contact#Donations).
