/*
 * SPDX-FileCopyrightText: 2001-2015 Klaralvdalens Datakonsult AB. All rights reserved.
 *
 * This file is part of the KD Chart library.
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#ifndef KCHARTBARATTRIBUTES_H
#define KCHARTBARATTRIBUTES_H

#include "KChartGlobal.h"
#include <QMetaType>

namespace KChart
{

/**
 * @brief Set of attributes for changing the appearance of bar charts
 */
class KCHART_EXPORT BarAttributes
{
public:
    BarAttributes();
    BarAttributes(const BarAttributes &);
    BarAttributes &operator=(const BarAttributes &);

    ~BarAttributes();

    void setFixedDataValueGap(qreal gap);
    qreal fixedDataValueGap() const;

    void setUseFixedDataValueGap(bool gapIsFixed);
    bool useFixedDataValueGap() const;

    void setFixedValueBlockGap(qreal gap);
    qreal fixedValueBlockGap() const;

    void setUseFixedValueBlockGap(bool gapIsFixed);
    bool useFixedValueBlockGap() const;

    void setFixedBarWidth(qreal width);
    qreal fixedBarWidth() const;

    void setUseFixedBarWidth(bool useFixedBarWidth);
    bool useFixedBarWidth() const;

    void setGroupGapFactor(qreal gapFactor);
    qreal groupGapFactor() const;

    void setBarGapFactor(qreal gapFactor);
    qreal barGapFactor() const;

    void setDrawSolidExcessArrows(bool solidArrows);
    bool drawSolidExcessArrows() const;

    bool operator==(const BarAttributes &) const;
    inline bool operator!=(const BarAttributes &other) const
    {
        return !operator==(other);
    }

private:
    class Private;
    Private *_d;
    Private *d_func()
    {
        return _d;
    }
    const Private *d_func() const
    {
        return _d;
    }
}; // End of class BarAttributes

}

Q_DECLARE_METATYPE(KChart::BarAttributes)

#endif // KCHARTBARATTRIBUTES_H
