/*
  SPDX-FileCopyrightText: 2010 Tobias Koenig <tokoe@kde.org>

  SPDX-License-Identifier: LGPL-2.0-or-later
*/

#pragma once

#include "akonadi-contact-widgets_export.h"

#include <KJob>

#include <memory>

namespace Akonadi
{
class OpenEmailAddressJobPrivate;

/*!
 * \class Akonadi::OpenEmailAddressJob
 * \brief A job to open the contact editor for a contact with a given email address.
 * \inmodule AkonadiContactWidgets
 * \inheaderfile Akonadi/OpenEmailAddressJob
 *
 * The job will check whether a contact with the given email address already
 * exists in Akonadi. If not, it will add a new contact with the email address
 * to Akonadi and then opens the contact editor.
 */
class AKONADI_CONTACT_WIDGETS_EXPORT OpenEmailAddressJob : public KJob
{
    Q_OBJECT

public:
    /*!
     * Creates a new open email address job.
     *
     * \a email The email address to open.
     * \a parentWidget The widget that will be used as parent for dialog.
     * \a parent The parent object.
     */
    explicit OpenEmailAddressJob(const QString &email, QWidget *parentWidget, QObject *parent = nullptr);

    /*!
     * Destroys the open email address job.
     */
    ~OpenEmailAddressJob() override;

    /*!
     * Starts the job.
     */
    void start() override;

private:
    friend class OpenEmailAddressJobPrivate;
    std::unique_ptr<OpenEmailAddressJobPrivate> const d;
};
}
