﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/databrew/model/S3Location.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace GlueDataBrew {
namespace Model {

S3Location::S3Location(JsonView jsonValue) { *this = jsonValue; }

S3Location& S3Location::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Bucket")) {
    m_bucket = jsonValue.GetString("Bucket");
    m_bucketHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Key")) {
    m_key = jsonValue.GetString("Key");
    m_keyHasBeenSet = true;
  }
  if (jsonValue.ValueExists("BucketOwner")) {
    m_bucketOwner = jsonValue.GetString("BucketOwner");
    m_bucketOwnerHasBeenSet = true;
  }
  return *this;
}

JsonValue S3Location::Jsonize() const {
  JsonValue payload;

  if (m_bucketHasBeenSet) {
    payload.WithString("Bucket", m_bucket);
  }

  if (m_keyHasBeenSet) {
    payload.WithString("Key", m_key);
  }

  if (m_bucketOwnerHasBeenSet) {
    payload.WithString("BucketOwner", m_bucketOwner);
  }

  return payload;
}

}  // namespace Model
}  // namespace GlueDataBrew
}  // namespace Aws
