﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/dataexchange/model/UpdateRevisionRequest.h>

#include <utility>

using namespace Aws::DataExchange::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateRevisionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_commentHasBeenSet) {
    payload.WithString("Comment", m_comment);
  }

  if (m_finalizedHasBeenSet) {
    payload.WithBool("Finalized", m_finalized);
  }

  return payload.View().WriteReadable();
}
