﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/deadline/model/AssociateMemberToFleetRequest.h>

#include <utility>

using namespace Aws::deadline::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String AssociateMemberToFleetRequest::SerializePayload() const {
  JsonValue payload;

  if (m_principalTypeHasBeenSet) {
    payload.WithString("principalType", PrincipalTypeMapper::GetNameForPrincipalType(m_principalType));
  }

  if (m_identityStoreIdHasBeenSet) {
    payload.WithString("identityStoreId", m_identityStoreId);
  }

  if (m_membershipLevelHasBeenSet) {
    payload.WithString("membershipLevel", MembershipLevelMapper::GetNameForMembershipLevel(m_membershipLevel));
  }

  return payload.View().WriteReadable();
}
