﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/deadline/model/ListSessionActionsRequest.h>

#include <utility>

using namespace Aws::deadline::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String ListSessionActionsRequest::SerializePayload() const { return {}; }

void ListSessionActionsRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_sessionIdHasBeenSet) {
    ss << m_sessionId;
    uri.AddQueryStringParameter("sessionId", ss.str());
    ss.str("");
  }

  if (m_taskIdHasBeenSet) {
    ss << m_taskId;
    uri.AddQueryStringParameter("taskId", ss.str());
    ss.str("");
  }

  if (m_nextTokenHasBeenSet) {
    ss << m_nextToken;
    uri.AddQueryStringParameter("nextToken", ss.str());
    ss.str("");
  }

  if (m_maxResultsHasBeenSet) {
    ss << m_maxResults;
    uri.AddQueryStringParameter("maxResults", ss.str());
    ss.str("");
  }
}
