﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/deadline/model/ListStorageProfilesResult.h>

#include <utility>

using namespace Aws::deadline::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListStorageProfilesResult::ListStorageProfilesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListStorageProfilesResult& ListStorageProfilesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("storageProfiles")) {
    Aws::Utils::Array<JsonView> storageProfilesJsonList = jsonValue.GetArray("storageProfiles");
    for (unsigned storageProfilesIndex = 0; storageProfilesIndex < storageProfilesJsonList.GetLength(); ++storageProfilesIndex) {
      m_storageProfiles.push_back(storageProfilesJsonList[storageProfilesIndex].AsObject());
    }
    m_storageProfilesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
