﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/detective/model/ListIndicatorsResult.h>

#include <utility>

using namespace Aws::Detective::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListIndicatorsResult::ListIndicatorsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListIndicatorsResult& ListIndicatorsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("GraphArn")) {
    m_graphArn = jsonValue.GetString("GraphArn");
    m_graphArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("InvestigationId")) {
    m_investigationId = jsonValue.GetString("InvestigationId");
    m_investigationIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Indicators")) {
    Aws::Utils::Array<JsonView> indicatorsJsonList = jsonValue.GetArray("Indicators");
    for (unsigned indicatorsIndex = 0; indicatorsIndex < indicatorsJsonList.GetLength(); ++indicatorsIndex) {
      m_indicators.push_back(indicatorsJsonList[indicatorsIndex].AsObject());
    }
    m_indicatorsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
