﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/detective/model/UpdateOrganizationConfigurationRequest.h>

#include <utility>

using namespace Aws::Detective::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateOrganizationConfigurationRequest::SerializePayload() const {
  JsonValue payload;

  if (m_graphArnHasBeenSet) {
    payload.WithString("GraphArn", m_graphArn);
  }

  if (m_autoEnableHasBeenSet) {
    payload.WithBool("AutoEnable", m_autoEnable);
  }

  return payload.View().WriteReadable();
}
