﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/dynamodb/model/BatchExecuteStatementRequest.h>

#include <utility>

using namespace Aws::DynamoDB::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String BatchExecuteStatementRequest::SerializePayload() const {
  JsonValue payload;

  if (m_statementsHasBeenSet) {
    Aws::Utils::Array<JsonValue> statementsJsonList(m_statements.size());
    for (unsigned statementsIndex = 0; statementsIndex < statementsJsonList.GetLength(); ++statementsIndex) {
      statementsJsonList[statementsIndex].AsObject(m_statements[statementsIndex].Jsonize());
    }
    payload.WithArray("Statements", std::move(statementsJsonList));
  }

  if (m_returnConsumedCapacityHasBeenSet) {
    payload.WithString("ReturnConsumedCapacity", ReturnConsumedCapacityMapper::GetNameForReturnConsumedCapacity(m_returnConsumedCapacity));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection BatchExecuteStatementRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "DynamoDB_20120810.BatchExecuteStatement"));
  return headers;
}
