﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/dynamodb/model/CancellationReason.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace DynamoDB {
namespace Model {

CancellationReason::CancellationReason(JsonView jsonValue) { *this = jsonValue; }

CancellationReason& CancellationReason::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Item")) {
    Aws::Map<Aws::String, JsonView> itemJsonMap = jsonValue.GetObject("Item").GetAllObjects();
    for (auto& itemItem : itemJsonMap) {
      m_item[itemItem.first] = itemItem.second.AsObject();
    }
    m_itemHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Code")) {
    m_code = jsonValue.GetString("Code");
    m_codeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Message")) {
    m_message = jsonValue.GetString("Message");
    m_messageHasBeenSet = true;
  }
  return *this;
}

JsonValue CancellationReason::Jsonize() const {
  JsonValue payload;

  if (m_itemHasBeenSet) {
    JsonValue itemJsonMap;
    for (auto& itemItem : m_item) {
      itemJsonMap.WithObject(itemItem.first, itemItem.second.Jsonize());
    }
    payload.WithObject("Item", std::move(itemJsonMap));
  }

  if (m_codeHasBeenSet) {
    payload.WithString("Code", m_code);
  }

  if (m_messageHasBeenSet) {
    payload.WithString("Message", m_message);
  }

  return payload;
}

}  // namespace Model
}  // namespace DynamoDB
}  // namespace Aws
