﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/elasticfilesystem/model/UpdateFileSystemResult.h>

#include <utility>

using namespace Aws::EFS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

UpdateFileSystemResult::UpdateFileSystemResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

UpdateFileSystemResult& UpdateFileSystemResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("OwnerId")) {
    m_ownerId = jsonValue.GetString("OwnerId");
    m_ownerIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CreationToken")) {
    m_creationToken = jsonValue.GetString("CreationToken");
    m_creationTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("FileSystemId")) {
    m_fileSystemId = jsonValue.GetString("FileSystemId");
    m_fileSystemIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("FileSystemArn")) {
    m_fileSystemArn = jsonValue.GetString("FileSystemArn");
    m_fileSystemArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CreationTime")) {
    m_creationTime = jsonValue.GetDouble("CreationTime");
    m_creationTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LifeCycleState")) {
    m_lifeCycleState = LifeCycleStateMapper::GetLifeCycleStateForName(jsonValue.GetString("LifeCycleState"));
    m_lifeCycleStateHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Name")) {
    m_name = jsonValue.GetString("Name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NumberOfMountTargets")) {
    m_numberOfMountTargets = jsonValue.GetInteger("NumberOfMountTargets");
    m_numberOfMountTargetsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("SizeInBytes")) {
    m_sizeInBytes = jsonValue.GetObject("SizeInBytes");
    m_sizeInBytesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("PerformanceMode")) {
    m_performanceMode = PerformanceModeMapper::GetPerformanceModeForName(jsonValue.GetString("PerformanceMode"));
    m_performanceModeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Encrypted")) {
    m_encrypted = jsonValue.GetBool("Encrypted");
    m_encryptedHasBeenSet = true;
  }
  if (jsonValue.ValueExists("KmsKeyId")) {
    m_kmsKeyId = jsonValue.GetString("KmsKeyId");
    m_kmsKeyIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ThroughputMode")) {
    m_throughputMode = ThroughputModeMapper::GetThroughputModeForName(jsonValue.GetString("ThroughputMode"));
    m_throughputModeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ProvisionedThroughputInMibps")) {
    m_provisionedThroughputInMibps = jsonValue.GetDouble("ProvisionedThroughputInMibps");
    m_provisionedThroughputInMibpsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("AvailabilityZoneName")) {
    m_availabilityZoneName = jsonValue.GetString("AvailabilityZoneName");
    m_availabilityZoneNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("AvailabilityZoneId")) {
    m_availabilityZoneId = jsonValue.GetString("AvailabilityZoneId");
    m_availabilityZoneIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Tags")) {
    Aws::Utils::Array<JsonView> tagsJsonList = jsonValue.GetArray("Tags");
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      m_tags.push_back(tagsJsonList[tagsIndex].AsObject());
    }
    m_tagsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("FileSystemProtection")) {
    m_fileSystemProtection = jsonValue.GetObject("FileSystemProtection");
    m_fileSystemProtectionHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
