﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/elasticmapreduce/model/AutoScalingPolicyStatus.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace EMR {
namespace Model {

AutoScalingPolicyStatus::AutoScalingPolicyStatus(JsonView jsonValue) { *this = jsonValue; }

AutoScalingPolicyStatus& AutoScalingPolicyStatus::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("State")) {
    m_state = AutoScalingPolicyStateMapper::GetAutoScalingPolicyStateForName(jsonValue.GetString("State"));
    m_stateHasBeenSet = true;
  }
  if (jsonValue.ValueExists("StateChangeReason")) {
    m_stateChangeReason = jsonValue.GetObject("StateChangeReason");
    m_stateChangeReasonHasBeenSet = true;
  }
  return *this;
}

JsonValue AutoScalingPolicyStatus::Jsonize() const {
  JsonValue payload;

  if (m_stateHasBeenSet) {
    payload.WithString("State", AutoScalingPolicyStateMapper::GetNameForAutoScalingPolicyState(m_state));
  }

  if (m_stateChangeReasonHasBeenSet) {
    payload.WithObject("StateChangeReason", m_stateChangeReason.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace EMR
}  // namespace Aws
