﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/elasticmapreduce/model/CreatePersistentAppUIResult.h>

#include <utility>

using namespace Aws::EMR::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

CreatePersistentAppUIResult::CreatePersistentAppUIResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

CreatePersistentAppUIResult& CreatePersistentAppUIResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("PersistentAppUIId")) {
    m_persistentAppUIId = jsonValue.GetString("PersistentAppUIId");
    m_persistentAppUIIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("RuntimeRoleEnabledCluster")) {
    m_runtimeRoleEnabledCluster = jsonValue.GetBool("RuntimeRoleEnabledCluster");
    m_runtimeRoleEnabledClusterHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
