﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/es/model/AddTagsRequest.h>

#include <utility>

using namespace Aws::ElasticsearchService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String AddTagsRequest::SerializePayload() const {
  JsonValue payload;

  if (m_aRNHasBeenSet) {
    payload.WithString("ARN", m_aRN);
  }

  if (m_tagListHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagListJsonList(m_tagList.size());
    for (unsigned tagListIndex = 0; tagListIndex < tagListJsonList.GetLength(); ++tagListIndex) {
      tagListJsonList[tagListIndex].AsObject(m_tagList[tagListIndex].Jsonize());
    }
    payload.WithArray("TagList", std::move(tagListJsonList));
  }

  return payload.View().WriteReadable();
}
