﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/es/model/CreateElasticsearchDomainRequest.h>

#include <utility>

using namespace Aws::ElasticsearchService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String CreateElasticsearchDomainRequest::SerializePayload() const {
  JsonValue payload;

  if (m_domainNameHasBeenSet) {
    payload.WithString("DomainName", m_domainName);
  }

  if (m_elasticsearchVersionHasBeenSet) {
    payload.WithString("ElasticsearchVersion", m_elasticsearchVersion);
  }

  if (m_elasticsearchClusterConfigHasBeenSet) {
    payload.WithObject("ElasticsearchClusterConfig", m_elasticsearchClusterConfig.Jsonize());
  }

  if (m_eBSOptionsHasBeenSet) {
    payload.WithObject("EBSOptions", m_eBSOptions.Jsonize());
  }

  if (m_accessPoliciesHasBeenSet) {
    payload.WithString("AccessPolicies", m_accessPolicies);
  }

  if (m_snapshotOptionsHasBeenSet) {
    payload.WithObject("SnapshotOptions", m_snapshotOptions.Jsonize());
  }

  if (m_vPCOptionsHasBeenSet) {
    payload.WithObject("VPCOptions", m_vPCOptions.Jsonize());
  }

  if (m_cognitoOptionsHasBeenSet) {
    payload.WithObject("CognitoOptions", m_cognitoOptions.Jsonize());
  }

  if (m_encryptionAtRestOptionsHasBeenSet) {
    payload.WithObject("EncryptionAtRestOptions", m_encryptionAtRestOptions.Jsonize());
  }

  if (m_nodeToNodeEncryptionOptionsHasBeenSet) {
    payload.WithObject("NodeToNodeEncryptionOptions", m_nodeToNodeEncryptionOptions.Jsonize());
  }

  if (m_advancedOptionsHasBeenSet) {
    JsonValue advancedOptionsJsonMap;
    for (auto& advancedOptionsItem : m_advancedOptions) {
      advancedOptionsJsonMap.WithString(advancedOptionsItem.first, advancedOptionsItem.second);
    }
    payload.WithObject("AdvancedOptions", std::move(advancedOptionsJsonMap));
  }

  if (m_logPublishingOptionsHasBeenSet) {
    JsonValue logPublishingOptionsJsonMap;
    for (auto& logPublishingOptionsItem : m_logPublishingOptions) {
      logPublishingOptionsJsonMap.WithObject(LogTypeMapper::GetNameForLogType(logPublishingOptionsItem.first),
                                             logPublishingOptionsItem.second.Jsonize());
    }
    payload.WithObject("LogPublishingOptions", std::move(logPublishingOptionsJsonMap));
  }

  if (m_domainEndpointOptionsHasBeenSet) {
    payload.WithObject("DomainEndpointOptions", m_domainEndpointOptions.Jsonize());
  }

  if (m_advancedSecurityOptionsHasBeenSet) {
    payload.WithObject("AdvancedSecurityOptions", m_advancedSecurityOptions.Jsonize());
  }

  if (m_autoTuneOptionsHasBeenSet) {
    payload.WithObject("AutoTuneOptions", m_autoTuneOptions.Jsonize());
  }

  if (m_tagListHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagListJsonList(m_tagList.size());
    for (unsigned tagListIndex = 0; tagListIndex < tagListJsonList.GetLength(); ++tagListIndex) {
      tagListJsonList[tagListIndex].AsObject(m_tagList[tagListIndex].Jsonize());
    }
    payload.WithArray("TagList", std::move(tagListJsonList));
  }

  return payload.View().WriteReadable();
}
