﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/es/model/CreateOutboundCrossClusterSearchConnectionResult.h>

#include <utility>

using namespace Aws::ElasticsearchService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

CreateOutboundCrossClusterSearchConnectionResult::CreateOutboundCrossClusterSearchConnectionResult(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

CreateOutboundCrossClusterSearchConnectionResult& CreateOutboundCrossClusterSearchConnectionResult::operator=(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("SourceDomainInfo")) {
    m_sourceDomainInfo = jsonValue.GetObject("SourceDomainInfo");
    m_sourceDomainInfoHasBeenSet = true;
  }
  if (jsonValue.ValueExists("DestinationDomainInfo")) {
    m_destinationDomainInfo = jsonValue.GetObject("DestinationDomainInfo");
    m_destinationDomainInfoHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ConnectionAlias")) {
    m_connectionAlias = jsonValue.GetString("ConnectionAlias");
    m_connectionAliasHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ConnectionStatus")) {
    m_connectionStatus = jsonValue.GetObject("ConnectionStatus");
    m_connectionStatusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CrossClusterSearchConnectionId")) {
    m_crossClusterSearchConnectionId = jsonValue.GetString("CrossClusterSearchConnectionId");
    m_crossClusterSearchConnectionIdHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
