﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/es/model/ListDomainNamesRequest.h>

#include <utility>

using namespace Aws::ElasticsearchService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String ListDomainNamesRequest::SerializePayload() const { return {}; }

void ListDomainNamesRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_engineTypeHasBeenSet) {
    ss << EngineTypeMapper::GetNameForEngineType(m_engineType);
    uri.AddQueryStringParameter("engineType", ss.str());
    ss.str("");
  }
}
