﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/es/model/LogPublishingOption.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace ElasticsearchService {
namespace Model {

LogPublishingOption::LogPublishingOption(JsonView jsonValue) { *this = jsonValue; }

LogPublishingOption& LogPublishingOption::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("CloudWatchLogsLogGroupArn")) {
    m_cloudWatchLogsLogGroupArn = jsonValue.GetString("CloudWatchLogsLogGroupArn");
    m_cloudWatchLogsLogGroupArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Enabled")) {
    m_enabled = jsonValue.GetBool("Enabled");
    m_enabledHasBeenSet = true;
  }
  return *this;
}

JsonValue LogPublishingOption::Jsonize() const {
  JsonValue payload;

  if (m_cloudWatchLogsLogGroupArnHasBeenSet) {
    payload.WithString("CloudWatchLogsLogGroupArn", m_cloudWatchLogsLogGroupArn);
  }

  if (m_enabledHasBeenSet) {
    payload.WithBool("Enabled", m_enabled);
  }

  return payload;
}

}  // namespace Model
}  // namespace ElasticsearchService
}  // namespace Aws
