﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/es/model/UpdateElasticsearchDomainConfigRequest.h>

#include <utility>

using namespace Aws::ElasticsearchService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateElasticsearchDomainConfigRequest::SerializePayload() const {
  JsonValue payload;

  if (m_elasticsearchClusterConfigHasBeenSet) {
    payload.WithObject("ElasticsearchClusterConfig", m_elasticsearchClusterConfig.Jsonize());
  }

  if (m_eBSOptionsHasBeenSet) {
    payload.WithObject("EBSOptions", m_eBSOptions.Jsonize());
  }

  if (m_snapshotOptionsHasBeenSet) {
    payload.WithObject("SnapshotOptions", m_snapshotOptions.Jsonize());
  }

  if (m_vPCOptionsHasBeenSet) {
    payload.WithObject("VPCOptions", m_vPCOptions.Jsonize());
  }

  if (m_cognitoOptionsHasBeenSet) {
    payload.WithObject("CognitoOptions", m_cognitoOptions.Jsonize());
  }

  if (m_advancedOptionsHasBeenSet) {
    JsonValue advancedOptionsJsonMap;
    for (auto& advancedOptionsItem : m_advancedOptions) {
      advancedOptionsJsonMap.WithString(advancedOptionsItem.first, advancedOptionsItem.second);
    }
    payload.WithObject("AdvancedOptions", std::move(advancedOptionsJsonMap));
  }

  if (m_accessPoliciesHasBeenSet) {
    payload.WithString("AccessPolicies", m_accessPolicies);
  }

  if (m_logPublishingOptionsHasBeenSet) {
    JsonValue logPublishingOptionsJsonMap;
    for (auto& logPublishingOptionsItem : m_logPublishingOptions) {
      logPublishingOptionsJsonMap.WithObject(LogTypeMapper::GetNameForLogType(logPublishingOptionsItem.first),
                                             logPublishingOptionsItem.second.Jsonize());
    }
    payload.WithObject("LogPublishingOptions", std::move(logPublishingOptionsJsonMap));
  }

  if (m_domainEndpointOptionsHasBeenSet) {
    payload.WithObject("DomainEndpointOptions", m_domainEndpointOptions.Jsonize());
  }

  if (m_advancedSecurityOptionsHasBeenSet) {
    payload.WithObject("AdvancedSecurityOptions", m_advancedSecurityOptions.Jsonize());
  }

  if (m_nodeToNodeEncryptionOptionsHasBeenSet) {
    payload.WithObject("NodeToNodeEncryptionOptions", m_nodeToNodeEncryptionOptions.Jsonize());
  }

  if (m_encryptionAtRestOptionsHasBeenSet) {
    payload.WithObject("EncryptionAtRestOptions", m_encryptionAtRestOptions.Jsonize());
  }

  if (m_autoTuneOptionsHasBeenSet) {
    payload.WithObject("AutoTuneOptions", m_autoTuneOptions.Jsonize());
  }

  if (m_dryRunHasBeenSet) {
    payload.WithBool("DryRun", m_dryRun);
  }

  return payload.View().WriteReadable();
}
