﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/eventbridge/model/ListEndpointsRequest.h>

#include <utility>

using namespace Aws::EventBridge::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String ListEndpointsRequest::SerializePayload() const {
  JsonValue payload;

  if (m_namePrefixHasBeenSet) {
    payload.WithString("NamePrefix", m_namePrefix);
  }

  if (m_homeRegionHasBeenSet) {
    payload.WithString("HomeRegion", m_homeRegion);
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("NextToken", m_nextToken);
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("MaxResults", m_maxResults);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection ListEndpointsRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSEvents.ListEndpoints"));
  return headers;
}
