﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/eventbridge/model/PartnerEventSourceAccount.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace EventBridge {
namespace Model {

PartnerEventSourceAccount::PartnerEventSourceAccount(JsonView jsonValue) { *this = jsonValue; }

PartnerEventSourceAccount& PartnerEventSourceAccount::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Account")) {
    m_account = jsonValue.GetString("Account");
    m_accountHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CreationTime")) {
    m_creationTime = jsonValue.GetDouble("CreationTime");
    m_creationTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ExpirationTime")) {
    m_expirationTime = jsonValue.GetDouble("ExpirationTime");
    m_expirationTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("State")) {
    m_state = EventSourceStateMapper::GetEventSourceStateForName(jsonValue.GetString("State"));
    m_stateHasBeenSet = true;
  }
  return *this;
}

JsonValue PartnerEventSourceAccount::Jsonize() const {
  JsonValue payload;

  if (m_accountHasBeenSet) {
    payload.WithString("Account", m_account);
  }

  if (m_creationTimeHasBeenSet) {
    payload.WithDouble("CreationTime", m_creationTime.SecondsWithMSPrecision());
  }

  if (m_expirationTimeHasBeenSet) {
    payload.WithDouble("ExpirationTime", m_expirationTime.SecondsWithMSPrecision());
  }

  if (m_stateHasBeenSet) {
    payload.WithString("State", EventSourceStateMapper::GetNameForEventSourceState(m_state));
  }

  return payload;
}

}  // namespace Model
}  // namespace EventBridge
}  // namespace Aws
