﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/evs/model/DisassociateEipFromVlanRequest.h>

#include <utility>

using namespace Aws::EVS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DisassociateEipFromVlanRequest::SerializePayload() const {
  JsonValue payload;

  if (m_clientTokenHasBeenSet) {
    payload.WithString("clientToken", m_clientToken);
  }

  if (m_environmentIdHasBeenSet) {
    payload.WithString("environmentId", m_environmentId);
  }

  if (m_vlanNameHasBeenSet) {
    payload.WithString("vlanName", m_vlanName);
  }

  if (m_associationIdHasBeenSet) {
    payload.WithString("associationId", m_associationId);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DisassociateEipFromVlanRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AmazonElasticVMwareService.DisassociateEipFromVlan"));
  return headers;
}
