﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/evs/model/InitialVlanInfo.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace EVS {
namespace Model {

InitialVlanInfo::InitialVlanInfo(JsonView jsonValue) { *this = jsonValue; }

InitialVlanInfo& InitialVlanInfo::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("cidr")) {
    m_cidr = jsonValue.GetString("cidr");
    m_cidrHasBeenSet = true;
  }
  return *this;
}

JsonValue InitialVlanInfo::Jsonize() const {
  JsonValue payload;

  if (m_cidrHasBeenSet) {
    payload.WithString("cidr", m_cidr);
  }

  return payload;
}

}  // namespace Model
}  // namespace EVS
}  // namespace Aws
