﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/fis/model/UpdateSafetyLeverStateInput.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace FIS {
namespace Model {

UpdateSafetyLeverStateInput::UpdateSafetyLeverStateInput(JsonView jsonValue) { *this = jsonValue; }

UpdateSafetyLeverStateInput& UpdateSafetyLeverStateInput::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("status")) {
    m_status = SafetyLeverStatusInputMapper::GetSafetyLeverStatusInputForName(jsonValue.GetString("status"));
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("reason")) {
    m_reason = jsonValue.GetString("reason");
    m_reasonHasBeenSet = true;
  }
  return *this;
}

JsonValue UpdateSafetyLeverStateInput::Jsonize() const {
  JsonValue payload;

  if (m_statusHasBeenSet) {
    payload.WithString("status", SafetyLeverStatusInputMapper::GetNameForSafetyLeverStatusInput(m_status));
  }

  if (m_reasonHasBeenSet) {
    payload.WithString("reason", m_reason);
  }

  return payload;
}

}  // namespace Model
}  // namespace FIS
}  // namespace Aws
