﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/fms/model/GetProtectionStatusResult.h>

#include <utility>

using namespace Aws::FMS::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

GetProtectionStatusResult::GetProtectionStatusResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

GetProtectionStatusResult& GetProtectionStatusResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("AdminAccountId")) {
    m_adminAccountId = jsonValue.GetString("AdminAccountId");
    m_adminAccountIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ServiceType")) {
    m_serviceType = SecurityServiceTypeMapper::GetSecurityServiceTypeForName(jsonValue.GetString("ServiceType"));
    m_serviceTypeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Data")) {
    m_data = jsonValue.GetString("Data");
    m_dataHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
