﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/client/AWSError.h>
#include <aws/forecast/ForecastServiceErrorMarshaller.h>
#include <aws/forecast/ForecastServiceErrors.h>

using namespace Aws::Client;
using namespace Aws::ForecastService;

AWSError<CoreErrors> ForecastServiceErrorMarshaller::FindErrorByName(const char* errorName) const {
  AWSError<CoreErrors> error = ForecastServiceErrorMapper::GetErrorForName(errorName);
  if (error.GetErrorType() != CoreErrors::UNKNOWN) {
    return error;
  }

  return AWSErrorMarshaller::FindErrorByName(errorName);
}