﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/forecast/model/DeleteDatasetGroupRequest.h>

#include <utility>

using namespace Aws::ForecastService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteDatasetGroupRequest::SerializePayload() const {
  JsonValue payload;

  if (m_datasetGroupArnHasBeenSet) {
    payload.WithString("DatasetGroupArn", m_datasetGroupArn);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteDatasetGroupRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AmazonForecast.DeleteDatasetGroup"));
  return headers;
}
