﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/forecast/model/DeleteForecastRequest.h>

#include <utility>

using namespace Aws::ForecastService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteForecastRequest::SerializePayload() const {
  JsonValue payload;

  if (m_forecastArnHasBeenSet) {
    payload.WithString("ForecastArn", m_forecastArn);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteForecastRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AmazonForecast.DeleteForecast"));
  return headers;
}
