﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/forecast/model/DescribeMonitorRequest.h>

#include <utility>

using namespace Aws::ForecastService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DescribeMonitorRequest::SerializePayload() const {
  JsonValue payload;

  if (m_monitorArnHasBeenSet) {
    payload.WithString("MonitorArn", m_monitorArn);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DescribeMonitorRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AmazonForecast.DescribeMonitor"));
  return headers;
}
