﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/forecast/model/DescribeMonitorResult.h>

#include <utility>

using namespace Aws::ForecastService::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeMonitorResult::DescribeMonitorResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

DescribeMonitorResult& DescribeMonitorResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("MonitorName")) {
    m_monitorName = jsonValue.GetString("MonitorName");
    m_monitorNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("MonitorArn")) {
    m_monitorArn = jsonValue.GetString("MonitorArn");
    m_monitorArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ResourceArn")) {
    m_resourceArn = jsonValue.GetString("ResourceArn");
    m_resourceArnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Status")) {
    m_status = jsonValue.GetString("Status");
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LastEvaluationTime")) {
    m_lastEvaluationTime = jsonValue.GetDouble("LastEvaluationTime");
    m_lastEvaluationTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LastEvaluationState")) {
    m_lastEvaluationState = jsonValue.GetString("LastEvaluationState");
    m_lastEvaluationStateHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Baseline")) {
    m_baseline = jsonValue.GetObject("Baseline");
    m_baselineHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Message")) {
    m_message = jsonValue.GetString("Message");
    m_messageHasBeenSet = true;
  }
  if (jsonValue.ValueExists("CreationTime")) {
    m_creationTime = jsonValue.GetDouble("CreationTime");
    m_creationTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("LastModificationTime")) {
    m_lastModificationTime = jsonValue.GetDouble("LastModificationTime");
    m_lastModificationTimeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("EstimatedEvaluationTimeRemainingInMinutes")) {
    m_estimatedEvaluationTimeRemainingInMinutes = jsonValue.GetInt64("EstimatedEvaluationTimeRemainingInMinutes");
    m_estimatedEvaluationTimeRemainingInMinutesHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
