﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/glacier/model/GetJobOutputResult.h>

#include <utility>

using namespace Aws::Glacier::Model;
using namespace Aws::Utils::Stream;
using namespace Aws::Utils;
using namespace Aws;

GetJobOutputResult::GetJobOutputResult(Aws::AmazonWebServiceResult<ResponseStream>&& result) { *this = std::move(result); }

GetJobOutputResult& GetJobOutputResult::operator=(Aws::AmazonWebServiceResult<ResponseStream>&& result) {
  m_body = result.TakeOwnershipOfPayload();
  m_bodyHasBeenSet = true;

  const auto& headers = result.GetHeaderValueCollection();
  const auto& checksumIter = headers.find("x-amz-sha256-tree-hash");
  if (checksumIter != headers.end()) {
    m_checksum = checksumIter->second;
    m_checksumHasBeenSet = true;
  }

  const auto& contentRangeIter = headers.find("content-range");
  if (contentRangeIter != headers.end()) {
    m_contentRange = contentRangeIter->second;
    m_contentRangeHasBeenSet = true;
  }

  const auto& acceptRangesIter = headers.find("accept-ranges");
  if (acceptRangesIter != headers.end()) {
    m_acceptRanges = acceptRangesIter->second;
    m_acceptRangesHasBeenSet = true;
  }

  const auto& contentTypeIter = headers.find("content-type");
  if (contentTypeIter != headers.end()) {
    m_contentType = contentTypeIter->second;
    m_contentTypeHasBeenSet = true;
  }

  const auto& archiveDescriptionIter = headers.find("x-amz-archive-description");
  if (archiveDescriptionIter != headers.end()) {
    m_archiveDescription = archiveDescriptionIter->second;
    m_archiveDescriptionHasBeenSet = true;
  }

  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  m_status = static_cast<int>(result.GetResponseCode());
  m_statusHasBeenSet = true;
  return *this;
}
