﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/glue/model/DeleteDevEndpointRequest.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DeleteDevEndpointRequest::SerializePayload() const {
  JsonValue payload;

  if (m_endpointNameHasBeenSet) {
    payload.WithString("EndpointName", m_endpointName);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DeleteDevEndpointRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSGlue.DeleteDevEndpoint"));
  return headers;
}
