﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/glue/model/DescribeInboundIntegrationsRequest.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String DescribeInboundIntegrationsRequest::SerializePayload() const {
  JsonValue payload;

  if (m_integrationArnHasBeenSet) {
    payload.WithString("IntegrationArn", m_integrationArn);
  }

  if (m_markerHasBeenSet) {
    payload.WithString("Marker", m_marker);
  }

  if (m_maxRecordsHasBeenSet) {
    payload.WithInteger("MaxRecords", m_maxRecords);
  }

  if (m_targetArnHasBeenSet) {
    payload.WithString("TargetArn", m_targetArn);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection DescribeInboundIntegrationsRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSGlue.DescribeInboundIntegrations"));
  return headers;
}
