﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/glue/model/GetDatabasesRequest.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GetDatabasesRequest::SerializePayload() const {
  JsonValue payload;

  if (m_catalogIdHasBeenSet) {
    payload.WithString("CatalogId", m_catalogId);
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("NextToken", m_nextToken);
  }

  if (m_maxResultsHasBeenSet) {
    payload.WithInteger("MaxResults", m_maxResults);
  }

  if (m_resourceShareTypeHasBeenSet) {
    payload.WithString("ResourceShareType", ResourceShareTypeMapper::GetNameForResourceShareType(m_resourceShareType));
  }

  if (m_attributesToGetHasBeenSet) {
    Aws::Utils::Array<JsonValue> attributesToGetJsonList(m_attributesToGet.size());
    for (unsigned attributesToGetIndex = 0; attributesToGetIndex < attributesToGetJsonList.GetLength(); ++attributesToGetIndex) {
      attributesToGetJsonList[attributesToGetIndex].AsString(
          DatabaseAttributesMapper::GetNameForDatabaseAttributes(m_attributesToGet[attributesToGetIndex]));
    }
    payload.WithArray("AttributesToGet", std::move(attributesToGetJsonList));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetDatabasesRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSGlue.GetDatabases"));
  return headers;
}
