﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/glue/model/GetSchemaVersionsDiffRequest.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String GetSchemaVersionsDiffRequest::SerializePayload() const {
  JsonValue payload;

  if (m_schemaIdHasBeenSet) {
    payload.WithObject("SchemaId", m_schemaId.Jsonize());
  }

  if (m_firstSchemaVersionNumberHasBeenSet) {
    payload.WithObject("FirstSchemaVersionNumber", m_firstSchemaVersionNumber.Jsonize());
  }

  if (m_secondSchemaVersionNumberHasBeenSet) {
    payload.WithObject("SecondSchemaVersionNumber", m_secondSchemaVersionNumber.Jsonize());
  }

  if (m_schemaDiffTypeHasBeenSet) {
    payload.WithString("SchemaDiffType", SchemaDiffTypeMapper::GetNameForSchemaDiffType(m_schemaDiffType));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection GetSchemaVersionsDiffRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSGlue.GetSchemaVersionsDiff"));
  return headers;
}
