﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/glue/model/ListDataQualityStatisticAnnotationsResult.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListDataQualityStatisticAnnotationsResult::ListDataQualityStatisticAnnotationsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

ListDataQualityStatisticAnnotationsResult& ListDataQualityStatisticAnnotationsResult::operator=(
    const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("Annotations")) {
    Aws::Utils::Array<JsonView> annotationsJsonList = jsonValue.GetArray("Annotations");
    for (unsigned annotationsIndex = 0; annotationsIndex < annotationsJsonList.GetLength(); ++annotationsIndex) {
      m_annotations.push_back(annotationsJsonList[annotationsIndex].AsObject());
    }
    m_annotationsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
