﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/glue/model/UpdateGlueIdentityCenterConfigurationRequest.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateGlueIdentityCenterConfigurationRequest::SerializePayload() const {
  JsonValue payload;

  if (m_scopesHasBeenSet) {
    Aws::Utils::Array<JsonValue> scopesJsonList(m_scopes.size());
    for (unsigned scopesIndex = 0; scopesIndex < scopesJsonList.GetLength(); ++scopesIndex) {
      scopesJsonList[scopesIndex].AsString(m_scopes[scopesIndex]);
    }
    payload.WithArray("Scopes", std::move(scopesJsonList));
  }

  if (m_userBackgroundSessionsEnabledHasBeenSet) {
    payload.WithBool("UserBackgroundSessionsEnabled", m_userBackgroundSessionsEnabled);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdateGlueIdentityCenterConfigurationRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSGlue.UpdateGlueIdentityCenterConfiguration"));
  return headers;
}
