﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/glue/model/UpdateMLTransformRequest.h>

#include <utility>

using namespace Aws::Glue::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateMLTransformRequest::SerializePayload() const {
  JsonValue payload;

  if (m_transformIdHasBeenSet) {
    payload.WithString("TransformId", m_transformId);
  }

  if (m_nameHasBeenSet) {
    payload.WithString("Name", m_name);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("Description", m_description);
  }

  if (m_parametersHasBeenSet) {
    payload.WithObject("Parameters", m_parameters.Jsonize());
  }

  if (m_roleHasBeenSet) {
    payload.WithString("Role", m_role);
  }

  if (m_glueVersionHasBeenSet) {
    payload.WithString("GlueVersion", m_glueVersion);
  }

  if (m_maxCapacityHasBeenSet) {
    payload.WithDouble("MaxCapacity", m_maxCapacity);
  }

  if (m_workerTypeHasBeenSet) {
    payload.WithString("WorkerType", WorkerTypeMapper::GetNameForWorkerType(m_workerType));
  }

  if (m_numberOfWorkersHasBeenSet) {
    payload.WithInteger("NumberOfWorkers", m_numberOfWorkers);
  }

  if (m_timeoutHasBeenSet) {
    payload.WithInteger("Timeout", m_timeout);
  }

  if (m_maxRetriesHasBeenSet) {
    payload.WithInteger("MaxRetries", m_maxRetries);
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection UpdateMLTransformRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "AWSGlue.UpdateMLTransform"));
  return headers;
}
