﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/grafana/model/ListWorkspaceServiceAccountsResult.h>

#include <utility>

using namespace Aws::ManagedGrafana::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListWorkspaceServiceAccountsResult::ListWorkspaceServiceAccountsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

ListWorkspaceServiceAccountsResult& ListWorkspaceServiceAccountsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("serviceAccounts")) {
    Aws::Utils::Array<JsonView> serviceAccountsJsonList = jsonValue.GetArray("serviceAccounts");
    for (unsigned serviceAccountsIndex = 0; serviceAccountsIndex < serviceAccountsJsonList.GetLength(); ++serviceAccountsIndex) {
      m_serviceAccounts.push_back(serviceAccountsJsonList[serviceAccountsIndex].AsObject());
    }
    m_serviceAccountsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("workspaceId")) {
    m_workspaceId = jsonValue.GetString("workspaceId");
    m_workspaceIdHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
