﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/greengrass/model/UpdateGroupCertificateConfigurationRequest.h>

#include <utility>

using namespace Aws::Greengrass::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String UpdateGroupCertificateConfigurationRequest::SerializePayload() const {
  JsonValue payload;

  if (m_certificateExpiryInMillisecondsHasBeenSet) {
    payload.WithString("CertificateExpiryInMilliseconds", m_certificateExpiryInMilliseconds);
  }

  return payload.View().WriteReadable();
}
