﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/greengrassv2/model/DescribeComponentResult.h>

#include <utility>

using namespace Aws::GreengrassV2::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeComponentResult::DescribeComponentResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

DescribeComponentResult& DescribeComponentResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("arn")) {
    m_arn = jsonValue.GetString("arn");
    m_arnHasBeenSet = true;
  }
  if (jsonValue.ValueExists("componentName")) {
    m_componentName = jsonValue.GetString("componentName");
    m_componentNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("componentVersion")) {
    m_componentVersion = jsonValue.GetString("componentVersion");
    m_componentVersionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("creationTimestamp")) {
    m_creationTimestamp = jsonValue.GetDouble("creationTimestamp");
    m_creationTimestampHasBeenSet = true;
  }
  if (jsonValue.ValueExists("publisher")) {
    m_publisher = jsonValue.GetString("publisher");
    m_publisherHasBeenSet = true;
  }
  if (jsonValue.ValueExists("description")) {
    m_description = jsonValue.GetString("description");
    m_descriptionHasBeenSet = true;
  }
  if (jsonValue.ValueExists("status")) {
    m_status = jsonValue.GetObject("status");
    m_statusHasBeenSet = true;
  }
  if (jsonValue.ValueExists("platforms")) {
    Aws::Utils::Array<JsonView> platformsJsonList = jsonValue.GetArray("platforms");
    for (unsigned platformsIndex = 0; platformsIndex < platformsJsonList.GetLength(); ++platformsIndex) {
      m_platforms.push_back(platformsJsonList[platformsIndex].AsObject());
    }
    m_platformsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("tags")) {
    Aws::Map<Aws::String, JsonView> tagsJsonMap = jsonValue.GetObject("tags").GetAllObjects();
    for (auto& tagsItem : tagsJsonMap) {
      m_tags[tagsItem.first] = tagsItem.second.AsString();
    }
    m_tagsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
