﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>
#include <aws/inspector/model/DescribeExclusionsResult.h>

#include <utility>

using namespace Aws::Inspector::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

DescribeExclusionsResult::DescribeExclusionsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

DescribeExclusionsResult& DescribeExclusionsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("exclusions")) {
    Aws::Map<Aws::String, JsonView> exclusionsJsonMap = jsonValue.GetObject("exclusions").GetAllObjects();
    for (auto& exclusionsItem : exclusionsJsonMap) {
      m_exclusions[exclusionsItem.first] = exclusionsItem.second.AsObject();
    }
    m_exclusionsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("failedItems")) {
    Aws::Map<Aws::String, JsonView> failedItemsJsonMap = jsonValue.GetObject("failedItems").GetAllObjects();
    for (auto& failedItemsItem : failedItemsJsonMap) {
      m_failedItems[failedItemsItem.first] = failedItemsItem.second.AsObject();
    }
    m_failedItemsHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
