﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/iotevents/model/IotSiteWiseAction.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace IoTEvents {
namespace Model {

IotSiteWiseAction::IotSiteWiseAction(JsonView jsonValue) { *this = jsonValue; }

IotSiteWiseAction& IotSiteWiseAction::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("entryId")) {
    m_entryId = jsonValue.GetString("entryId");
    m_entryIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("assetId")) {
    m_assetId = jsonValue.GetString("assetId");
    m_assetIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("propertyId")) {
    m_propertyId = jsonValue.GetString("propertyId");
    m_propertyIdHasBeenSet = true;
  }
  if (jsonValue.ValueExists("propertyAlias")) {
    m_propertyAlias = jsonValue.GetString("propertyAlias");
    m_propertyAliasHasBeenSet = true;
  }
  if (jsonValue.ValueExists("propertyValue")) {
    m_propertyValue = jsonValue.GetObject("propertyValue");
    m_propertyValueHasBeenSet = true;
  }
  return *this;
}

JsonValue IotSiteWiseAction::Jsonize() const {
  JsonValue payload;

  if (m_entryIdHasBeenSet) {
    payload.WithString("entryId", m_entryId);
  }

  if (m_assetIdHasBeenSet) {
    payload.WithString("assetId", m_assetId);
  }

  if (m_propertyIdHasBeenSet) {
    payload.WithString("propertyId", m_propertyId);
  }

  if (m_propertyAliasHasBeenSet) {
    payload.WithString("propertyAlias", m_propertyAlias);
  }

  if (m_propertyValueHasBeenSet) {
    payload.WithObject("propertyValue", m_propertyValue.Jsonize());
  }

  return payload;
}

}  // namespace Model
}  // namespace IoTEvents
}  // namespace Aws
