﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/iotevents/model/ResetTimerAction.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace IoTEvents {
namespace Model {

ResetTimerAction::ResetTimerAction(JsonView jsonValue) { *this = jsonValue; }

ResetTimerAction& ResetTimerAction::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("timerName")) {
    m_timerName = jsonValue.GetString("timerName");
    m_timerNameHasBeenSet = true;
  }
  return *this;
}

JsonValue ResetTimerAction::Jsonize() const {
  JsonValue payload;

  if (m_timerNameHasBeenSet) {
    payload.WithString("timerName", m_timerName);
  }

  return payload;
}

}  // namespace Model
}  // namespace IoTEvents
}  // namespace Aws
