﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/ivs/model/StreamFilters.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace IVS {
namespace Model {

StreamFilters::StreamFilters(JsonView jsonValue) { *this = jsonValue; }

StreamFilters& StreamFilters::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("health")) {
    m_health = StreamHealthMapper::GetStreamHealthForName(jsonValue.GetString("health"));
    m_healthHasBeenSet = true;
  }
  return *this;
}

JsonValue StreamFilters::Jsonize() const {
  JsonValue payload;

  if (m_healthHasBeenSet) {
    payload.WithString("health", StreamHealthMapper::GetNameForStreamHealth(m_health));
  }

  return payload;
}

}  // namespace Model
}  // namespace IVS
}  // namespace Aws
